/* Tanzania Wave 2 general firm data using cleaned version of
data tz2new incorporating changes made in light of 
Wave 4 survey information */

libname tz 'd:\tanzrped\sasdata';
libname cd 'd:\tanzrped\createdata';



/* ****************************************** */
/* setting up firm characteristics for wave 2 */
/* ****************************************** */

data check1; set tz.tz2new;
options nolabel;

wave=2;
firm=v0no;
if v0no=11 then firm=1;

name=v0name;
owner=v0own;

/* industrial sector */
if indu=1 then indlab='food';
if indu=2 then indlab='textile';
if indu=3 then indlab='wood';
if indu=4 then indlab='metal';

if indu=1 then food=1; else food=0;
if indu=2 then text=1; else text=0;
if indu=3 then wood=1; else wood=0;
if indu=4 then metal=1; else metal=0;

/* type of firm */
if sect=1 then sectlab='informal';
if sect=2 then sectlab='formal';
if sect=3 then sectlab='parastat';
if sect=4 then sectlab='service';

/* firm ownership */
change=v0201a;
if sect=3 then state=1; else state=0;

/* firm size dummies */
empft=v2102r1;
emppt=v2102r2+v2102r3;
empchk=empft+emppt;
emp=v2101;

if emp=0 then emp=emp+1;

emp93=emp;

if emp ge 1 and emp le 5 then size93=1;
if emp ge 6 and emp le 29 then size93=2;
if emp ge 30 and emp le 99 then size93=3;
if emp ge 100 then size93=4;

if size93=1 then sizedum='amicro';
if size93=2 then sizedum='bsmall';
if size93=3 then sizedum='cmedium';
if size93=4 then sizedum='dlarge';

if size93=1 then micro=1; else micro=0;
if size93=2 then small=1; else small=0;
if size93=3 then medium=1; else medium=0;
if size93=4 then large=1; else large=0;


/* firm location dummies */
if loca=1 then loclab='DES';
if loca=2 then loclab='Morogoro';
if loca=3 then loclab='Tanga';
if loca=4 then loclab='Arusha';
if loca=5 then loclab='Mwanza';
if loca=6 then loclab='Iringa';

if loca=1 then DES=1; else DES=0;
if loca=2 then morog=1; else morog=0;
if loca=3 then tanga=1; else tanga=0;
if loca=4 then arusha=1; else arusha=0;
if loca=5 then mwanza=1; else mwanza=0;
if loca=6 then iringa=1; else iringa=0;


keep firm wave indu indlab sect sectlab change state
emp empft emppt loca loclab size93 sizedum
name owner food text wood metal repl emp93
DES morog tanga arusha mwanza iringa
micro small medium large name;

data cd.w2chars; set check1;
proc sort; by firm;


/* ****************************************** */
/* setting up variables for wave 2 production */
/*                function                    */
/* ****************************************** */

data check2; set tz.tz2new; by firm;
options linesize=80;
options nolabel;

wave=2;
firm=key;

accts=v1101;
period=v1102;

output=v1216;
sales=v1217;
inctrad=v1218;
incserv=v1219;
incoth=v1220;

/* calculate sales for firms without accounts as check */
if v1214r1=. then v1214r1=0;
if v1214r2=. then v1214r2=0;
if v1214r3=. then v1214r3=0;
if v1214r4=. then v1214r4=0;
if v1214r5=. then v1214r5=0;
salesb=v1214r1+v1214r2+v1214r3+v1214r4+v1214r5;
if salesb=0 then salesb=.;

/* where output is missing use sales figure */

if output=. then output=sales;
if output=. then output=salesb;

/* calculate raw material costs */

rawmat=v1327;

if v1215r1=. then v1215r1=0;
if v1215r2=. then v1215r2=0;
if v1215r3=. then v1215r3=0;
if v1215r4=. then v1215r4=0;
if v1215r5=. then v1215r5=0;
rawmatb=v1215r1+v1215r2+v1215r3+v1215r4+v1215r5;
if rawmatb=0 then rawmatb=.;

if rawmat=. then rawmat=rawmatb;

rent=v1436a;
elec=v1436b;
water=v1436c;
telef=v1436d;
lfuel=v1436e;
sfuel=v1436f;
trans=v1436g;
secur=v1436h;
advert=v1437;
other=v1438;

if rent=. then rent=0;
if elec=. then elec=0;
if water=. then water=0;
if telef=. then telef=0;
if lfuel=. then lfuel=0;
if sfuel=. then sfuel=0;
if trans=. then trans=0;
if secur=. then secur=0;
if advert=. then advert=0;
if other=. then other=0;

misc=rent+elec+water+telef+lfuel+sfuel+trans+secur+advert+other;
if misc=0 then misc=.;

wages=v1330;
labcost=v1331;
if labcost=. then labcost=wages;

profit=v1440;

/* section to annualise production data */

if period=1 then output=output;
if period=2 then output=output*2;
if period=3 then output=output*12;
if period=4 then output=output*52/2;
if period=5 then output=output*52;
if period=6 then output=output*260;

if period=1 then sales=sales;
if period=2 then sales=sales*2;
if period=3 then sales=sales*12;
if period=4 then sales=sales*52/2;
if period=5 then sales=sales*52;
if period=6 then output=output*260;

if period=1 then rawmat=rawmat;
if period=2 then rawmat=rawmat*2;
if period=3 then rawmat=rawmat*12;
if period=4 then rawmat=rawmat*52/2;
if period=5 then rawmat=rawmat*52;
if period=6 then output=output*260;

if period=1 then misc=misc;
if period=2 then misc=misc*2;
if period=3 then misc=misc*12;
if period=4 then misc=misc*52/2;
if period=5 then misc=misc*52;
if period=6 then output=output*260;

if period=1 then wages=wages;
if period=2 then wages=wages*2;
if period=3 then wages=wages*12;
if period=4 then wages=wages*52/2;
if period=5 then wages=wages*52;
if period=6 then output=output*260;

if period=1 then labcost=labcost;
if period=2 then labcost=labcost*2;
if period=3 then labcost=labcost*12;
if period=4 then labcost=labcost*52/2;
if period=5 then labcost=labcost*52;
if period=6 then output=output*260;

if period=1 then profit=profit;
if period=2 then profit=profit*2;
if period=3 then profit=profit*12;
if period=4 then profit=profit*52/2;
if period=5 then profit=profit*52;
if period=6 then output=output*260;

if period=. then delete;
if period gt 6 then delete;

/* revisions to components of VAD based upon checks and Wave 4
information */
if firm=65 then output=10798920;
if firm=65 then rawmat=5674835;
if firm=76 then output=623497000;
if firm=121 then output=3000000;
if firm=205 then rawmat=5520000;
if firm=220 then rawmat=1000000;
if firm=427 then misc=396400000;
if firm=606 then misc=63774237;
if firm=531 then output=3100000;

cap=v1332b;
capsale=v1333b;
caplb=v1332a;
capsallb=v1333a;
if cap=. then cap=capsale;

/* adjustments to cap stock using information
from other waves or using resale value where this seems
more reliable */

if firm=607 then cap=125800000;
if firm=109 then cap=178800;
if firm=301 then cap=5500000;
if firm=609 then cap=250000000;
if firm=606 then cap=3000000000;
if firm=603 then cap=10000000;
if firm=51 then cap=1500000;
if firm=422 then cap=10000000000;
if firm=102 then cap=50000000;
if firm=411 then cap=30000000;
if firm=527 then cap=460000000; /* wave 1 figure plus invest of 10m */
if firm=611 then cap=50000000; /* sale value */
if firm=206 then cap=30000000;
if firm=107 then cap=300000000; /* sale value */
if firm=121 then cap=2400000; /* wave 3 value */
if firm=530 then cap=500000;
if firm=420 then cap=1000000000;
if firm=620 then cap=200000000;

emp=v2101;
if emp=0 then emp=emp+1;

capemp=cap/emp;

vad=output-misc-rawmat;
if misc=. then vad=output-rawmat;

/* adjustments to make consistent with other waves */
if firm=62 then vad=19323000;

prcalc=vad-labcost;
prate=profit/cap;

vademp=vad/emp;
vadcap=vad/cap;
capvad=cap/vad;

export=v1549;
if export=1 then expdum=1; else expdum=0;
expaf=v1550a;
expnaf=v1550b;

output93=output;
sales93=sales;
rawmat93=rawmat;
misc93=misc;
wages93=wages;
labc93=labcost;
cap93=cap;
capsal93=capsale;
emp93=emp;
vad93=vad;
prof93=profit;
expdum93=expdum;
expaf93=expaf;
expnaf93=expnaf;
capemp93=capemp;
vademp93=vademp;
vadcap93=vadcap;
capvad93=capvad;
prate93=prate;
prcalc93=prcalc;

/* firms with no financial data in Wave 2; either missing observations
or firms temp or permanently stopped production */
if firm=3 then delete;
if firm=5 then delete;
if firm=9 then delete;
if firm=16 then delete; /* data unreliable */
if firm=17 then delete;
if firm=19 then delete;
if firm=20 then delete;
if firm=25 then delete;
if firm=27 then delete;
if firm=28 then delete;
if firm=35 then delete;
if firm=38 then delete;
if firm=40 then delete;
if firm=53 then delete;
if firm=55 then delete;
if firm=64 then delete;
if firm=72 then delete;
if firm=85 then delete;
if firm=87 then delete;
if firm=94 then delete;
if firm=95 then delete;
if firm=106 then delete;
if firm=213 then delete;
if firm=408 then delete;
if firm=412 then delete;
if firm=509 then delete;
if firm=516 then delete;
if firm=608 then delete;
if firm=612 then delete;
if firm=225 then delete; /* tourism firm */
if firm=610 then delete; /* exclude in all waves */


keep firm wave accts period output sales inctrad incserv incoth
rawmat misc wages labcost cap capsale caplb capsallb emp capemp
vad vademp vadcap capvad profit prate prcalc export expaf expnaf expdum
output93 sales93 rawmat93 misc93 wages93 labc93 cap93 capsal93
emp93 vad93 prof93 expdum93 expaf93 expnaf93 capemp93 vademp93
vadcap93 capvad93 prate93 prcalc93;

/* proc means; run; */
/* proc print; var firm output vad cap emp; run; */

/* to eliminate firms with missing VAD from calculations
data check3; set check2;
if vad=. then delete;
proc means; run;
*/


/* creates permanent data file with 
general firm variables for wave 2 */

data cd.genfirm2; merge check2 (in=a) check1; by firm; if a;
proc means; run;


/* ************************************* */
/* basic production functions for Wave 2 */
/* ************************************* */

data check4; merge check2 (in=a) check1; by firm; if a;
options nolabel;

if vad<=0 then delete;

if vadcap gt 50 then delete;
if capvad gt 100 then delete;

lvad=log(vad);
lemp=log(emp);
lcap=log(cap);

proc means; var firm vad emp cap vadcap capvad; run;
proc reg; model lvad=lcap lemp;
run;


/* production function with ownership variables for Wave 2 */

data check4; merge cd.genfirm2 cd.owners; by firm;
options nolabel;

if vad lt 0 then delete;

if vadcap gt 50 then delete;
if capvad gt 100 then delete;


lvad=log(vad);
lemp=log(emp);
lcap=log(cap);

proc means; var firm vad emp cap vadcap capvad; run;
proc reg; model lvad=lcap lemp union privdom state ;
run;


/* cross tabs on key firm characteristics */

data temp3a; merge check2 (in=a) check1; by firm; if a;

proc means; var firm output emp cap vad vademp capemp
capvad vadcap; run;

proc sort; by size93;
proc means; var firm output emp cap vad vademp capemp
capvad vadcap; by size93; run;

proc sort; by indlab;
proc means; var firm output emp cap vad vademp capemp
capvad vadcap; by indlab; run;

proc sort; by sect;
proc means; var output emp cap capemp; by sect; run;

proc sort; by size93;
proc means; var firm emp cap output vad; by size93; run;



